PSCAD 4.2.0

Settings
 {
 Id = "922686631.1144434205"
 Author = "reform.jayas"
 Desc = "Active Filter - parallel configuration"
 Arch = "windows"
 Options = 0
 Build = 22
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 1e-005
  Plot = 1e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "Workshop3.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 50.0 [Hz]
chfreq_is_twice_the_freq = 
chfreq = 100.0 [Hz]
  freq = 50.0 [Hz]
chfreq_is_twice_the_freq = 
chfreq = 100.0 [Hz]
  freq = 50.0 [Hz]
chfreq_is_twice_the_freq = 
chfreq = 100.0 [Hz]
  }

 }

Definitions
 {
 Component("AlphaBeta_ABC")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Parameters")
    {
    Choice("Mode",6,2,180,12,2)
     {
     Style = 0
     Desc = "Direction of Transformation:"
     Def = "0"
     Len = 15
     *0 = "ABC to AlphaBeta"
     *1 = "AlphaBeta to ABC"
     }
    Choice("Zero",6,16,180,12,2)
     {
     Style = 0
     Desc = "With Zero-Sequence Component"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    }
   }

  Nodes = 
   {
   Input("IALP",-72,-36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("IBET",-72,0)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("ZER",-72,36)
    {
    Cond = "(Mode) && (Zero)"
    Type = Real
    }
   Output("IA",72,-36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Output("IB",72,0)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Output("IC",72,36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("IA",-72,-36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Input("IB",-72,0)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Input("IC",-72,36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("IALP",72,-36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("IBET",72,0)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("ZER",72,36)
    {
    Cond = "!(Mode) && (Zero)"
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-44,-45,45,44)
   Cond = "(Mode==1)"
   Line(-71,-36,-44,-36)
   Text(-63,-34,"Alpha")
   Line(-50,-41,-44,-36)
   Line(-44,-36,-50,-30)
   Line(72,-36,45,-36)
   Text(63,-34,"A")
   Line(-71,0,-44,0)
   Text(-63,1,"Beta")
   Line(-50,-5,-44,0)
   Line(-44,0,-50,5)
   Line(72,0,45,0)
   Text(63,1,"B")
   Line(72,35,45,35)
   Text(63,37,"C")
   Cond = "(Mode==1) && (Zero==1)"
   Line(-71,35,-44,35)
   Text(-63,37,"Zero")
   Line(-50,30,-44,35)
   Line(-44,35,-50,41)
   Cond = "(Mode==1)"
   Text(0,-6,"AlphaBeta")
   Text(0,6,"to")
   Text(0,16,"ABC")
   Cond = "(Mode==0)"
   Line(-71,-36,-44,-36)
   Text(-63,-34,"A")
   Line(-50,-41,-44,-36)
   Line(-44,-36,-50,-30)
   Line(72,-36,45,-36)
   Text(63,-34,"Alpha")
   Line(-71,0,-44,0)
   Text(-63,1,"B")
   Line(-50,-5,-44,0)
   Line(-44,0,-50,5)
   Line(72,0,45,0)
   Text(63,1,"Beta")
   Line(-71,35,-44,35)
   Text(-63,37,"C")
   Line(-50,30,-44,35)
   Line(-44,35,-50,41)
   Cond = "(Mode==0) && (Zero==1)"
   Line(72,35,45,35)
   Text(63,37,"Zero")
   Cond = "(Mode==0)"
   Text(0,-6,"ABC")
   Text(0,6,"to")
   Text(0,16,"AlphaBeta")
   }

  Section(EMTDC)
   {
   FORTRAN = "\
#SUBROUTINE ALBEABC AlphaBeta transformation
!
!  AlphaBeta transformation:
!
#IF Mode==1
!  ------------------------------------
!  Transformation from AlphaBeta to ABC
!  ------------------------------------
       $IA = SQRT(2.0/3.0)*$IALP
       $IB = SQRT(2.0/3.0)*0.5*(-$IALP + SQRT(3.0)*$IBET)
       $IC = SQRT(2.0/3.0)*0.5*(-$IALP - SQRT(3.0)*$IBET)
#IF Zero==1
       $IA = $IA + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
       $IB = $IB + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
       $IC = $IC + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
#ENDIF
#ELSE
!  ------------------------------------
!  Transformation from ABC to AlphaBeta
!  ------------------------------------
       $IALP = SQRT(2.0/3.0)*0.5*(2.0*$IA - $IB - $IC)
       $IBET = SQRT(2.0/3.0)*SQRT(3.0)*0.5*($IB - $IC)
#IF Zero==1
       $ZER  = SQRT(2.0/3.0)*($IA + $IB + $IC)/SQRT(2.0)
#ENDIF
#ENDIF"
   FILES = "\
cbpwm.f
"
   }
  }
 Module("ctrl")
  {
  Desc = ""
  FileDate = 1144434151
  Nodes = 
   {
   Output("G1",36,-54)
    {
    Type = Real
    Dim  = [2]
    }
   Output("G2",36,-36)
    {
    Type = Real
    Dim  = [2]
    }
   Output("G3",36,-18)
    {
    Type = Real
    Dim  = [2]
    }
   Output("G4",36,18)
    {
    Type = Real
    Dim  = [2]
    }
   Output("G5",36,36)
    {
    Type = Real
    Dim  = [2]
    }
   Output("G6",36,54)
    {
    Type = Real
    Dim  = [2]
    }
   Input("IF",-36,0)
    {
    Type = Real
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-26,-67,26,66)
   Line(26,-54,36,-54)
   Line(-36,0,-26,0)
   Line(-31,3,-26,0)
   Line(-26,0,-31,-3)
   Line(26,-36,36,-36)
   Line(26,-18,36,-18)
   Line(26,18,36,18)
   Line(26,36,36,36)
   Line(26,54,36,54)
   Text(2,-5,"Control")
   Text(2,7,"System")
   }


  Page(A/A4,Portrait,176,[597,467],100)
   {
   0.mult([144,1278],0,0,330)
    {
    }
   0.mult([144,1350],0,0,290)
    {
    }
   -Wire-([108,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([108,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([216,1314],0,0,340)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([180,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([180,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([108,1278],2,0,-1)
    {
    Name = "Vaph"
    }
   0.datalabel([108,1314],2,0,-1)
    {
    Name = "Pinst"
    }
   0.datalabel([108,1350],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([108,1386],2,0,-1)
    {
    Name = "Qinst"
    }
   0.mult([144,1422],0,0,360)
    {
    }
   0.mult([144,1494],0,0,300)
    {
    }
   -Wire-([108,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([108,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([216,1458],0,0,370)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([180,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([180,1494],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([108,1458],2,0,-1)
    {
    Name = "Pinst"
    }
   0.datalabel([108,1530],2,0,-1)
    {
    Name = "Qinst"
    }
   0.datalabel([108,1422],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([108,1494],2,0,-1)
    {
    Name = "Vaph"
    }
   0.div([288,1314],0,0,350)
    {
    }
   0.div([288,1458],0,0,380)
    {
    }
   0.datalabel([288,1350],0,0,-1)
    {
    Name = "a2pb2"
    }
   0.datalabel([288,1494],0,0,-1)
    {
    Name = "a2pb2"
    }
   -Wire-([324,1458],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([324,1350],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([468,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([396,846],2,0,-1)
    {
    Name = "Vaph"
    }
   0.mult([432,846],0,0,220)
    {
    }
   0.datalabel([432,882],0,0,-1)
    {
    Name = "Vaph"
    }
   0.sumjct([504,882],0,0,280)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([468,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.mult([432,918],0,0,230)
    {
    }
   0.datalabel([396,918],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([432,954],0,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([468,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([540,882],2,0,-1)
    {
    Name = "a2pb2"
    }
   0.gain([540,1350],0,0,400)
    {
    G = "GR"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([576,1422],2,0,-1)
    {
    Name = "IcRef"
    }
   0.datalabel([576,1386],2,0,-1)
    {
    Name = "IbRef"
    }
   0.datalabel([576,1350],2,0,-1)
    {
    Name = "IaRef"
    }
   0.gain([540,1386],0,0,430)
    {
    G = "GR"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([540,1422],0,0,420)
    {
    G = "GR"
    COM = "Gain"
    Dim = "1"
    }
   0.var([504,1476],0,23371376,150)
    {
    Name = "RefGain"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "-2"
    Value = "1.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([576,1476],2,0,-1)
    {
    Name = "GR"
    }
   -Wire-([540,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([90,1152],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 90,1152,270,1224
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Calculation of  alpha, beta of current which become the reference current for active filter"
    }
   -Sticky-([486,1224],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 486,1224,666,1296
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Reference currents which are fed into current control of active filter"
    }
   -Sticky-([342,1224],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 342,1224,450,1296
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Transformation of alpha, beta currents into phase currents"
    }
   .AlphaBeta_ABC([396,1386],0,0,390)
    {
    Mode = "1"
    Zero = "0"
    }
   0.sumjct([954,1404],0,0,520)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([954,1440],0,0,-1)
    {
    Name = "IcRef"
    }
   0.pgb([990,1404],0,22623152,580)
    {
    Name = "IcP"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.sumjct([846,1404],0,0,530)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([846,1440],0,0,-1)
    {
    Name = "IbRef"
    }
   0.pgb([882,1404],0,22726072,590)
    {
    Name = "IbP"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.sumjct([738,1404],0,0,540)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([738,1440],0,0,-1)
    {
    Name = "IaRef"
    }
   0.pgb([774,1404],0,22765304,600)
    {
    Name = "IaP"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([774,1224],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 774,1224,918,1296
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Theortical system current after 'correction' by reference current"
    }
   -Sticky-([90,648],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 90,648,432,666
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "CURRENT CONTROL OF ACTIVE FILTER"
    }
   -Wire-([162,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([234,882],0,0,460)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([270,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([270,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([234,972],0,0,440)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([234,828],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([234,918],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([234,1008],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([270,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([234,792],0,0,410)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.fp_int([1026,918],0,0,570)
    {
    Type = "1"
    PNum = "1"
    Blck = "1"
    PFormat = "0"
    detect = "0"
    max = "360.0 [deg]"
    min = "0.0 [deg]"
    BType = "0"
    PTime = "0.005 [s]"
    }
   0.datalabel([306,792],2,0,-1)
    {
    Name = "err_A"
    }
   0.datalabel([306,882],2,0,-1)
    {
    Name = "err_B"
    }
   0.datalabel([306,972],2,0,-1)
    {
    Name = "err_C"
    }
   0.datalabel([684,774],2,0,-1)
    {
    Name = "err_A"
    }
   0.const([864,702],0,0,90)
    {
    Name = ""
    Value = "0.002"
    }
   0.datamerge([774,864],4,0,510)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   0.datalabel([684,828],2,0,-1)
    {
    Name = "err_B"
    }
   0.datalabel([684,882],2,0,-1)
    {
    Name = "err_C"
    }
   0.datalabel([612,792],1,0,-1)
    {
    Name = "err_C"
    }
   0.gain([648,792],0,0,470)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([648,846],0,0,450)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([648,900],0,0,500)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([612,846],1,0,-1)
    {
    Name = "err_A"
    }
   0.datalabel([612,900],1,0,-1)
    {
    Name = "err_B"
    }
   -Wire-([684,774],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([684,792],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([684,828],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([684,846],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([684,882],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([684,900],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([756,774],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([756,882],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([738,864],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([738,792],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([756,810],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([756,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([810,918],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datamerge([918,774],4,0,110)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([900,702],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([612,954],1,0,-1)
    {
    Name = "err_A"
    }
   0.datamerge([774,1044],4,0,560)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   0.datalabel([612,1008],1,0,-1)
    {
    Name = "err_B"
    }
   0.datalabel([612,1062],1,0,-1)
    {
    Name = "err_C"
    }
   0.datalabel([684,972],0,0,-1)
    {
    Name = "err_C"
    }
   0.gain([648,954],0,0,490)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([648,1008],0,0,480)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([648,1062],0,0,550)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([684,1026],0,0,-1)
    {
    Name = "err_A"
    }
   0.datalabel([684,1080],0,0,-1)
    {
    Name = "err_B"
    }
   -Wire-([684,954],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([684,972],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([684,1008],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([684,1026],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([684,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([684,1080],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([756,954],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([756,1062],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([738,1044],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([738,972],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([756,990],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([756,1044],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([810,1098],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([810,918],2,0,-1)
    {
    Name = "H_on"
    }
   0.datalabel([810,1098],2,0,-1)
    {
    Name = "H_off"
    }
   0.datalabel([954,810],2,0,-1)
    {
    Name = "H_on"
    }
   0.datalabel([954,882],2,0,-1)
    {
    Name = "H_off"
    }
   -Wire-([954,846],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([990,810],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([990,846],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([990,882],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([990,918],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([918,828],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Sticky-([810,756],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 810,756,882,828
    Alignment = 1
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Hysteresis width for current PWM"
    }
   -Wire-([162,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([162,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([162,792],0,0,-1)
    {
    Name = "IaRef"
    }
   0.datalabel([162,882],0,0,-1)
    {
    Name = "IbRef"
    }
   0.datalabel([162,972],0,0,-1)
    {
    Name = "IcRef"
    }
   -Sticky-([144,702],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 144,702,342,738
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Current error calculations"
    }
   -Sticky-([594,684],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 594,684,774,720
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Calculations of firing pulses"
    }
   0.pgb([144,468],0,22838248,710)
    {
    Name = "IaRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([108,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([144,504],0,22831496,700)
    {
    Name = "IbRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([108,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([144,540],0,22832032,690)
    {
    Name = "IcRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,342],2,0,-1)
    {
    Name = "Vaph"
    }
   0.datalabel([378,378],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([378,234],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([378,270],2,0,-1)
    {
    Name = "Ibta"
    }
   -Wire-([342,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([342,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([342,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([342,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([198,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 198,126,342,180
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Transformation of phase quantities into alpha, beta ones"
    }
   .AlphaBeta_ABC([270,270],0,0,160)
    {
    Mode = "0"
    Zero = "0"
    }
   0.datalabel([1062,288],2,0,-1)
    {
    Name = "Pinst"
    }
   0.mult([702,252],0,0,240)
    {
    }
   0.datalabel([666,252],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([666,288],2,0,-1)
    {
    Name = "Vaph"
    }
   0.mult([702,324],0,0,250)
    {
    }
   0.datalabel([666,324],2,0,-1)
    {
    Name = "Ibta"
    }
   0.datalabel([666,360],2,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([666,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([666,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([774,288],0,0,310)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([738,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.cmplx([918,288],0,0,320)
    {
    G = "1.0"
    DR = "0.2"
    F = "$(chfreq)"
    HP = "1"
    MP = "0"
    LP = "0"
    }
   0.pgb([846,288],3,22783504,730)
    {
    Name = "p_inst"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([990,288],3,22785696,720)
    {
    Name = "p_inst filtered"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([810,288],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([954,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Sticky-([648,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 648,126,864,180
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Calculation of instantaneous real power based on alpha, beta quantities"
    }
   -Sticky-([918,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 918,126,1134,180
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "After filtering of real power 'p' only ac component of the instantaneous  real power is left"
    }
   0.mult([702,504],0,0,180)
    {
    }
   0.datalabel([666,504],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([666,576],2,0,-1)
    {
    Name = "Ibta"
    }
   -Wire-([666,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([774,540],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([738,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,540],2,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([810,540],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.cmplx([918,540],0,0,270)
    {
    G = "1.0"
    DR = "0.2"
    F = "$(chfreq)"
    HP = "1"
    MP = "0"
    LP = "0"
    }
   0.pgb([846,540],3,22814504,680)
    {
    Name = "q_inst"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([990,540],3,23249440,670)
    {
    Name = "q_inst filtered"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([954,540],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.mult([702,576],0,0,190)
    {
    }
   -Wire-([666,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,612],2,0,-1)
    {
    Name = "Vaph"
    }
   0.datalabel([1062,540],2,0,-1)
    {
    Name = "Qinst"
    }
   -Sticky-([648,378],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 648,378,864,432
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Calculation of instantaneous reactive power based on alpha, beta quantities"
    }
   -Sticky-([918,378],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 918,378,1134,432
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "After filtering of reactive power 'q' only ac component of the instantaneous  reactive power is left"
    }
   .AlphaBeta_ABC([270,378],0,0,170)
    {
    Mode = "0"
    Zero = "0"
    }
   -Wire-([90,1134],0,0,-1)
    {
    Vertex="0,0;1044,0"
    }
   -Wire-([90,630],0,0,-1)
    {
    Vertex="0,0;1044,0"
    }
   -Sticky-([0,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 0,18,1224,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
A SIMPLIFIED ACTIVE FILTER IN PARALLEL CONFIGURATION
Control Subpage"
    }
   0.radiolink([432,468],4,0,10)
    {
    Source = "Main"
    Name = "V"
    dim = "3"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([432,522],4,0,50)
    {
    Source = "Main"
    Name = "IL"
    dim = "3"
    Mode = "0"
    Type = "0"
    }
   0.datalabel([468,540],0,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([504,540],0,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([540,540],0,0,-1)
    {
    Name = "Ic"
    }
   0.datalabel([198,234],0,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([198,270],0,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([198,306],0,0,-1)
    {
    Name = "Ic"
    }
   0.datalabel([738,1368],6,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([846,1368],6,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([954,1368],6,0,-1)
    {
    Name = "Ic"
    }
   -Wire-([432,468],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datalabel([468,486],0,0,-1)
    {
    Name = "Va"
    }
   0.datatap([468,486],0,0,20)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,486],0,0,30)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([540,486],0,0,40)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([504,486],0,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([540,486],0,0,-1)
    {
    Name = "Vc"
    }
   0.datalabel([198,342],0,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([198,378],0,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([198,414],0,0,-1)
    {
    Name = "Vc"
    }
   -Wire-([108,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([108,540],0,0,-1)
    {
    Name = "IcRef"
    }
   0.datalabel([108,504],0,0,-1)
    {
    Name = "IbRef"
    }
   0.datalabel([108,468],0,0,-1)
    {
    Name = "IaRef"
    }
   -Wire-([432,522],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datatap([468,540],0,0,60)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,540],0,0,70)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([540,540],0,0,80)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.import([72,864],0,0,120)
    {
    Name = "IF"
    }
   -Wire-([108,990],0,0,-1)
    {
    Vertex="0,0;0,-180"
    }
   0.datatap([126,828],0,0,200)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([126,918],0,0,130)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([126,1008],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.export([1098,774],4,0,660)
    {
    Name = "G1"
    }
   0.export([1098,810],4,0,650)
    {
    Name = "G2"
    }
   0.export([1098,846],4,0,640)
    {
    Name = "G3"
    }
   0.export([1098,882],4,0,630)
    {
    Name = "G4"
    }
   0.export([1098,918],4,0,620)
    {
    Name = "G5"
    }
   0.export([1098,954],4,0,610)
    {
    Name = "G6"
    }
   0.var_switch([1098,738],4,23241904,100)
    {
    Name = "blocking"
    Group = "Filter"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "deblk"
    Toff = "blk"
    }
   0.unity([1026,738],4,0,210)
    {
    IType = "2"
    OType = "1"
    }
   }
  }
 Module("active")
  {
  Desc = ""
  FileDate = 1144434151
  Nodes = 
   {
   Electrical("V",0,-54)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-47,-29,47,207)
   Pen(ByNode,ByNode,ByNode)
   Line(0,-54,0,-29)
   Pen(Black,Solid,1.0)
   Line(0,16,0,-9)
   Line(-15,16,15,16)
   Line(-15,27,15,27)
   Line(0,46,0,27)
   Arc(-9,48,10,64,0,90)
   Arc(-9,48,10,64,360,-90)
   Arc(-9,64,10,81,0,90)
   Arc(-9,64,10,81,360,-90)
   Arc(-9,81,10,97,0,90)
   Arc(-9,81,10,97,360,-90)
   Line(0,112,0,96)
   Line(6,117,0,112)
   Line(-6,124,6,117)
   Line(-6,126,6,133)
   Line(-6,141,6,133)
   Line(-6,142,6,150)
   Line(6,151,0,156)
   Line(0,172,0,156)
   Line(-15,174,15,174)
   Line(-9,181,7,181)
   Line(-3,189,1,189)
   Line(-13,90,22,54)
   Line(15,55,21,54)
   Line(19,61,22,54)
   Text(3,229,"ACTIVE")
   Text(3,246,"FILTER")
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   -Wire-([288,342],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([396,198],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   -Wire-([396,486],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   0.voltmetergnd([666,198],0,0,10)
    {
    Name = "VFdc"
    }
   0.ground([180,378],1,0,-1)
    {
    }
   0.ground([198,378],1,0,-1)
    {
    }
   -Wire-([720,306],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   0.peswitch([396,234],2,0,180)
    {
    L = "1"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch1"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([432,270],4,0,20)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id1"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([396,198],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([432,234],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([432,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.peswitch([504,234],2,0,170)
    {
    L = "3"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch3"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([540,270],4,0,30)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id3"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([504,198],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([540,234],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([540,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([504,270],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.peswitch([612,234],2,0,160)
    {
    L = "5"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch5"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([648,270],4,0,40)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id5"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([612,198],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([648,234],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([648,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([612,270],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.peswitch([396,414],2,0,150)
    {
    L = "4"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch4"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([432,450],4,0,120)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id4"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([396,270],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([432,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([432,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([396,450],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([504,414],2,0,90)
    {
    L = "6"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch6"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([540,450],4,0,130)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id6"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([540,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([540,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([504,450],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([612,414],2,0,100)
    {
    L = "2"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch2"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([648,450],4,0,140)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id2"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([648,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([648,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([612,450],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([378,378],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   0.datalabel([360,270],0,0,-1)
    {
    Name = "G1"
    }
   0.datalabel([468,270],0,0,-1)
    {
    Name = "G3"
    }
   0.datalabel([576,270],0,0,-1)
    {
    Name = "G5"
    }
   0.datalabel([360,450],0,0,-1)
    {
    Name = "G4"
    }
   0.datalabel([468,450],0,0,-1)
    {
    Name = "G6"
    }
   0.datalabel([576,450],0,0,-1)
    {
    Name = "G2"
    }
   -Wire-([720,486],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   -Wire-([270,378],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.inductor([324,342],2,0,-1)
    {
    L = "0.001 [H]"
    }
   0.capacitor([270,414],3,0,-1)
    {
    C = "0.1 [uF]"
    }
   0.ground([270,414],1,0,-1)
    {
    }
   0.pin([270,342],3,0,-1)
    {
    }
   0.pin([396,306],0,0,-1)
    {
    }
   0.pin([504,342],0,0,-1)
    {
    }
   0.pin([612,378],0,0,-1)
    {
    }
   -Wire-([378,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.annotation([558,144],0,0,-1)
    {
    AL1 = "SIMPLIFIED"
    AL2 = "ACTIVE FILTER"
    }
   -Wire-([108,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.xnode([108,342],2,0,-1)
    {
    Name = "V"
    }
   0.datalabel([792,342],2,0,-1)
    {
    Name = "IFa"
    }
   0.pgb([864,396],0,23393144,110)
    {
    Name = "IF"
    Group = "Filter"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.08"
    Max = "0.06"
    }
   -Wire-([918,360],0,0,-1)
    {
    Vertex="0,0;-54,0;-54,36"
    }
   0.datalabel([810,342],2,0,-1)
    {
    Name = "IFb"
    }
   0.datalabel([828,342],2,0,-1)
    {
    Name = "IFc"
    }
   0.source1([720,342],1,0,60)
    {
    Name = "dc"
    Type = "1"
    Ctrl = "0"
    Vm = "0.185 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "0.5 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.001 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = "IFdc"
    }
   0.xfmr-3p2w([198,342],0,0,50)
    {
    Name = "T2"
    Tmva = "0.02 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.11 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "0.2 [kV]"
    V2 = "0.2 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = "IFa"
    ILB2 = "IFb"
    ILC2 = "IFc"
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   .ctrl([954,360],0,0,80)
    {
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 36,18,1188,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
A SIMPLIFIED ACTIVE FILTER IN PARALLEL CONFIGURATION
Active Filter Subpage"
    }
   -Wire-([1008,306],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1008,324],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1008,342],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1008,378],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1008,396],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1008,414],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([1008,306],4,0,-1)
    {
    Name = "G1"
    }
   0.datalabel([1008,324],4,0,-1)
    {
    Name = "G2"
    }
   0.datalabel([1008,342],4,0,-1)
    {
    Name = "G3"
    }
   0.datalabel([1008,378],4,0,-1)
    {
    Name = "G4"
    }
   0.datalabel([1008,396],4,0,-1)
    {
    Name = "G5"
    }
   0.datalabel([1008,414],4,0,-1)
    {
    Name = "G6"
    }
   0.breakout([342,342],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([324,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datamerge([864,360],3,0,70)
    {
    N = "3"
    Type = "2"
    Disp = "0"
    }
   }
  }
 Module("Main")
  {
  Desc = " "
  FileDate = 1144434151
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   0.pin([702,216],0,0,-1)
    {
    }
   0.annotation([630,126],0,0,-1)
    {
    AL1 = "VOLTAGE SOURCE"
    AL2 = "200 V, $(freq)"
    }
   0.fft([774,774],0,0,130)
    {
    Type = "3"
    Size = "1"
    F = "$(freq)"
    AMod = "0"
    PMod = "1"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = "\""
    }
   0.datalabel([738,702],2,0,-1)
    {
    Name = "IposS"
    }
   0.datalabel([666,738],0,0,-1)
    {
    Name = "ISa"
    }
   0.datalabel([666,774],0,0,-1)
    {
    Name = "ISb"
    }
   0.datalabel([666,810],0,0,-1)
    {
    Name = "ISc"
    }
   -Wire-([666,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([666,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([666,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([414,738],0,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([414,774],0,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([414,810],0,0,-1)
    {
    Name = "Ic"
    }
   0.datalabel([972,828],0,0,-1)
    {
    Name = "ISa"
    }
   0.pgb([1044,810],0,23415536,160)
    {
    Name = "IS"
    Group = "Source Current"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   0.datalabel([990,828],0,0,-1)
    {
    Name = "ISb"
    }
   0.datalabel([1008,828],0,0,-1)
    {
    Name = "ISc"
    }
   0.fft([522,774],0,0,120)
    {
    Type = "3"
    Size = "1"
    F = "$(freq)"
    AMod = "0"
    PMod = "1"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = "\""
    }
   0.datalabel([486,702],2,0,-1)
    {
    Name = "IpoL"
    }
   -Sticky-([810,396],0)
    {
    Name = ""
    Font = 1
    Bounds = 810,396,972,468
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Active Filter 6P STATCOM Based Device With Control System "
    }
   -Sticky-([72,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,72,504,342
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This application example is based on a case origionally created at the Manitoba HVDC Research Centre by Dr. M. Reformat, in Manitoba, Canada.

This case illustrates the use of a STATCOM to provide active filtering for the ac side of a 6-pulse converter system. The Active filter  is connected through a 20 kVA, Y-Y transformer to a 200 V, 50 Hz, 3-Phase bus, with a 6-pulse converter load

REFERENCE:
  H. Fujita and H. Akagi,
  'A Practical Approach to Harmonic Compensation
  in Power Systems - Series Connection of Passive
  and Active Filters', IEEE Trans. on Ind.Applications,
  vol.27, No.6, Nov/Dec 1991, pp. 1020-1025

Revised by J.E. Nordstrom - September 2000"
    }
   -Wire-([702,216],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([774,108],0,0,-1)
    {
    Vertex="0,0;126,0;126,18"
    }
   -Wire-([774,180],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.var_switch([1080,288],4,23423416,80)
    {
    Name = "blocking"
    Group = "Pulse Bridge Control"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "deblk"
    Toff = "blk"
    }
   -Wire-([972,270],0,0,-1)
    {
    Vertex="0,0;18,0;18,18;36,18"
    }
   0.ground([918,306],1,0,-1)
    {
    }
   0.ground([828,252],1,0,-1)
    {
    }
   0.mult([1008,252],2,0,200)
    {
    }
   -Sticky-([270,558],0)
    {
    Name = ""
    Font = 1
    Bounds = 270,558,486,630
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Harmonic Current Load 6-P  Rectifer Requires  5, 7, 11, 13, etc Harmonic Current 
"
    }
   0.emtconst([1044,216],2,0,50)
    {
    Name = "PI / 180"
    Value = "5"
    }
   0.nodeloop([774,216],0,0,30)
    {
    View = "1"
    }
   0.voltmetergnd([738,216],0,0,20)
    {
    Name = "V"
    }
   0.g6p200([918,216],0,0,210)
    {
    UP = "1"
    FP = "0"
    SNUB = "1"
    KV = "-2"
    View = "1"
    FR = "$(freq)"
    GP = "10.0"
    GI = "100.0"
    KP = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.001 [kV]"
    EBO = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = ""
    VCurr = ""
    SCurr = ""
    }
   -Wire-([666,216],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1098,144],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([918,126],0,0,-1)
    {
    Vertex="0,0;0,-18;180,-18"
    }
   0.resistor([1098,144],1,0,-1)
    {
    R = "2.5 [ohm]"
    }
   0.ground([1098,180],1,0,-1)
    {
    }
   0.xfmr-3p2w([846,216],0,0,40)
    {
    Name = "T1"
    Tmva = "0.02 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "1"
    Lead = "1"
    Xl = "0.2 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "0.2 [kV]"
    V2 = "0.2 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = "Ia"
    ILB1 = "Ib"
    ILC1 = "Ic"
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.var([1080,252],2,23433368,60)
    {
    Name = "angle"
    Group = "Pulse Bridge Control"
    Display = "0"
    Max = "90"
    Min = "0"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.source_3([630,216],0,0,10)
    {
    Name = "Source"
    Type = "1"
    Grnd = "1"
    View = "1"
    Spec = "0"
    VCtrl = "0"
    FCtrl = "0"
    Vm = "0.2 [kV]"
    Tc = "0.02 [s]"
    f = "$(freq)"
    Ph = "0.0 [deg]"
    Vbase = "230.0 [kV]"
    Sbase = "100.0 [MVA]"
    Vpu = "1.0 [pu]"
    PhT = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    R = "0.002 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    IA = "Isa"
    IB = "Isb"
    IC = "Isc"
    }
   .active([702,324],0,0,70)
    {
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 36,18,1188,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "A SIMPLIFIED ACTIVE FILTER IN PARALLEL CONFIGURATION "
    }
   0.datalabel([1008,630],0,0,-1)
    {
    Name = "Ipol"
    }
   0.pgb([1044,630],0,23437848,170)
    {
    Name = "Load Harmonics"
    Group = "Harmonics"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "0.08"
    }
   -Wire-([1008,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1008,594],0,0,-1)
    {
    Name = "IposS"
    }
   0.pgb([1044,594],0,23440800,180)
    {
    Name = "Source Harmonics"
    Group = "Harmonics"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "0.08"
    }
   -Wire-([1008,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([72,522],0)
    {
    Name = "Rectifier Load"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 72,522
    Extents = 0,0,144,126
    Slider(23433368)
    Switch(23423416)
    }
   -Plot-([72,900],0)
    {
    Title = "SYSTEM CURRENTS"
    Draw = 1
    Area = [0,0,540,630]
    Posn = [72,900]
    Icon = [-1,-1]
    Extents = 0,0,540,630
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,540,189],"Source Current")
     {
     Options = 0
     Units = "kA"
     Curve(23415536,"IS",0,,,)
     }
    Graph([0,189],[0,0,540,189],"Load Current")
     {
     Options = 0
     Units = "kA"
     Curve(23516496,"Iload",0,,,)
     }
    Graph([0,378],[0,0,540,189],"Filter Current")
     {
     Options = 0
     Units = "kA"
     Curve(23393144,"IF",0,,,)
     }
    }
   0.radiolink([1044,684],0,0,90)
    {
    Source = "Main"
    Name = "V"
    dim = "3"
    Mode = "1"
    Type = "0"
    }
   -Wire-([1044,684],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1008,684],4,0,-1)
    {
    Name = "V"
    }
   0.radiolink([1044,720],0,0,110)
    {
    Source = "Main"
    Name = "IL"
    dim = "3"
    Mode = "1"
    Type = "0"
    }
   0.datalabel([972,738],4,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([990,738],4,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([1008,738],4,0,-1)
    {
    Name = "Ic"
    }
   0.pgb([1044,756],0,23516496,140)
    {
    Name = "Iload"
    Group = "Transformer Current - Primary Winding"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.125"
    Max = "0.125"
    }
   -PolyMeter-(23437848,702,1116,1134,1314)
    {
    Title = "Load Harmonics"
    Flags = 2
    State = 1
    Icon = 612,1026
    Posn = 702,1116
    Extents = 0,0,432,198
    }
   -PolyMeter-(23440800,702,900,1134,1098)
    {
    Title = "Source Harmonics"
    Flags = 2
    State = 1
    Icon = 684,774
    Posn = 702,900
    Extents = 0,0,432,198
    }
   0.datamerge([1044,720],7,0,100)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   -Wire-([1044,756],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datamerge([1044,810],7,0,150)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   0.unity([1008,288],4,0,190)
    {
    IType = "2"
    OType = "1"
    }
   -ControlPanel-([72,702],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,0,0
    Switch(23241904)
    }
   -Sticky-([180,756],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,756,324,792
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Active Filter"
    }
   }
  }
 }

